param St := 0;
param A  := 1;
param B  := 2;
param C  := 3;
param D  := 4;
param E  := 5;
param F  := 6;
param G  := 7;
param H  := 8;
param I  := 9;
param J  :=10;
param K  :=11;
param Fi :=12;

set tasks := {St,A,B,C,D,E,F,G,H,I,J,K,Fi};

set pred[tasks] := <A> {St}, <B> {St}, <C> {B}, <D> {A,B},
                   <E> {A,C}, <F> {A}, <G> {A}, <H> {C,G},
		   <I> {H}, <J> {I}, <K> {C,F}, <Fi> {D,E,J,K}, <St> {};

param d[tasks] := <A> 1, <B> 1, <C> 3, <D> 2, <E> 3, <F> 2, <G> 1,
      	       	  <H> 3, <I> 1, <J> 3, <K> 4 default 0;

param u[tasks] := <K> 2, <C> 1, <D> 1, <E> 1, <F> 1, <H> 1, <J> 1 default 0;

param c[tasks] := <K> 5000, <C> 7000, <D> 3000, <E> 6000, 
                  <F> 6000, <H> 3000, <J> 5000 default 0;

var y[tasks] real >= 0;
var x[tasks] real >= 0;

minimize
obj: sum <i> in tasks : c[i] * x[i];
#obj: y[Fi];

subto dur: y[Fi] <= 8;

subto path: forall <i> in tasks : 
      	    	   if (card(pred[i]) > 0) then 
      	    	      forall <j> in pred[i] :
		   	  y[i] >= y[j] -x[j] + d[j] else 0 == 0 end;

subto bound: forall <i> in tasks:
      	     	    x[i] <= u[i];