#include "e12aug.hpp"
#include <fstream>
#include <sstream>
#include <cassert>

using namespace std;


Graph::Graph(const char *instance_name) {
  
  //tmp = strtok(strdup(id.c_str()), ":");
  char buf[255]; // line buffer
  //int nn, en = 0;
  int ide = -1; // for doublechecking file definition (counts the read edges)
  int idt = -1; // for doublechecking file definition (counts the read edges)
  
  std::ifstream is;
  is.open(instance_name);
  
  if (!is.is_open()) {
    cerr<<"Instance file not found\n";
    exit(1);
  }
  
  while (!is.eof()) {
    is.getline(buf, 255); // process each line
    //printf("%s\n", buf);
    fflush(stdout);
    switch (buf[0]) {
    case 'p': {
      char *tmp = strtok(buf, " "); // splits buf
      //cout<<tmp<<endl;
      tmp = strtok(0, " "); // and considers the second substd::std::string
      //tmp = strtok(tmp, " "); // now process for the first value
      //cout<<tmp<<endl;
      tmp = strtok(0, " ");
      num_of_vertices = atoi(tmp);
      tmp = strtok(0, " "); // and for the second one
      //en = atoi(tmp);
      // let's ignore everything else
      // create the matrix
      aug_adj_list.resize(num_of_vertices);
      tree_adj_list.resize(num_of_vertices);
      adjacency_matrix = new int *[num_of_vertices];
      sol_adjacency_matrix = new int *[num_of_vertices];
      for (int v = 0; v < num_of_vertices; v++) {
	adjacency_matrix[v] = new int [num_of_vertices];
	sol_adjacency_matrix[v] = new int [num_of_vertices];
	for (int w = 0; w < num_of_vertices; w++)
	  {
	    adjacency_matrix[v][w] = 0;
	    sol_adjacency_matrix[v][w] = 0;
	  }
	aug_adj_list[v].clear();
	tree_adj_list[v].clear();
      }
      aug_edges.clear();
      tree_edges.clear();
      //degree.resize(num_of_vertices,0);
    }
      break;
    case 'e': {
      // reads the edge information and add the edge between the 
      // corresponding nodes
      if (marcoverbose == 3)
	cout<<buf<<endl;
      char *tmp = strtok(buf, " "); // splits buf among the spaces
      tmp = strtok(0, " "); // consider the first number
      int v = atoi(tmp) - 1;
      tmp = strtok(0, " "); // and now the second one
      int w = atoi(tmp) - 1;
      tmp = strtok(0, " "); // and now the third one
      long double cost = atof(tmp);
      assert(w>=0 && w<num_of_vertices);
      assert(v>=0 && v<num_of_vertices);
      if (cost <= 0)
	{
	  cout<<w<<" "<<v<<endl;
	  cerr<<cost<<endl;
	cerr<<"Edge cost <= zero"<<endl;
	}
      if (v > w) {
	  int h = v;
	  v = w;
	  w = h;
	}
      if (adjacency_matrix[v][w] == 0) {
	ide++;
	Edge edge;
	edge.from = v;
	edge.to = w;
	//	      aedge->u  = (*itr5)->u;
	//aedge->v  = (*itr5)->v;
	edge.weight = cost;
	edge.idx = ide;
	aug_edges.insert(pair<const int, Edge>(ide, edge));
	aug_adj_list[v].push_back(w);
	aug_adj_list[w].push_back(v);
	adjacency_matrix[v][w] = adjacency_matrix[w][v] = ide;
      } else {
	if (aug_edges[adjacency_matrix[v][w]].weight>cost)
	  aug_edges[adjacency_matrix[v][w]].weight=cost;
      }
      
    }
      break;
    case 't': {
      // reads the edge information and add the edge between the 
      // corresponding nodes
      if (marcoverbose==3)
	cout<<buf<<endl;
      char *tmp = strtok(buf, " "); // splits buf among the spaces
      tmp = strtok(0, " "); // consider the first number
      int v = atoi(tmp) - 1;
      tmp = strtok(0, " "); // and now the second one
      int w = atoi(tmp) - 1;
      //	tmp = strtok(0, " "); // and now the third one
      //long cost = atoi(tmp);
      assert(w>=0 && w<num_of_vertices);
      assert(v>=0 && v<num_of_vertices);
      //if (adjacency_matrix[v][w] == 0)
      {
	idt++;
	if (v > w) {
	  int h = v;
	  v = w;
	  w = h;
	}
	
	Edge edge;
	edge.from = v;
	edge.to = w;
	//	      aedge->u  = (*itr5)->u;
	//aedge->v  = (*itr5)->v;
	edge.weight = 0;
	edge.idx = idt;
	tree_edges.insert(pair<const int, Edge>(idt, edge));
      }
      tree_adj_list[v].push_back(w);
      tree_adj_list[w].push_back(v);
      //adjacency_matrix[v][w] = adjacency_matrix[w][v] = 1;
    }
      break;
    case 'c':
    case ' ':
    case '\n':
      // ignore the comments and the empty lines
      break;
    default:
      //std::cerr << "Error while reading the input file " << id << std::endl
      //  << "the line " << buf << " was not understandable" << std::endl;
      break;
    }
  }
  
  is.close();
  
  cout<<"Instance read"<<endl;
}



void Graph::create_cuts() {
  cut.resize(num_of_vertices);
  ND.resize(num_of_vertices);
  col.resize(num_of_vertices);
 cut_order.resize(num_of_vertices);
 bridge.resize(num_of_vertices);
  _postorder.resize(num_of_vertices);
  inv_postorder.resize(num_of_vertices+1);
  for (int i=0; i<num_of_vertices; i++) {
    cut[i].first=-1;
    col[i]=0;
    cut[i].second.clear();
    ND[i]=0;
    _postorder[i]=0;
   cut_order[i] = -1;
   bridge[i]=-1;
  }
  
  cout<<"Postorder" <<endl;
  po=0;
  postorder(0);
  cout<<"Start Visit" <<endl;
  cid = -1;
  for (int u=1; u<=num_of_vertices; u++)
    visit_cut(inv_postorder[u]);
  cout<< "End visit" <<endl;
  
  if (marcoverbose>=3)
    {
      int l;
      for (l=0; l<num_of_vertices; l++) 
	cout<<l+1<<" "<<_postorder[l]<<endl;
      ofstream os("help.dat");
      std::vector<int>::iterator pt;
      std::vector<Edge> tmp;
      std::vector<Edge>::iterator p;
      std::vector<int> mask(num_of_vertices,-1);

      for (l=0; l<num_of_vertices-1; l++) 
	mask[cut[l].first]=l;

      for (int i=0; i<num_of_vertices; i++) {
	if (mask[i]<0)
	  continue;
	l = mask[i];
	os<<cut[l].first+1<<" "<<bridge[l]+1<< ": [";
	tmp.clear();
	for (pt=cut[l].second.begin(); pt!=cut[l].second.end(); pt++)
	  //cout<<aug_edges[*pt]<<" ";
	  tmp.push_back(aug_edges[*pt]);
	sort(tmp.begin(),tmp.end());
	for (p=tmp.begin();p!=tmp.end();p++)
	  os<<*p;
	
	//cout <<cut[l].first+1<<" [";
	//for (pt=cut[l].second.begin(); pt!=cut[l].second.end(); pt++)
	//	print_cut(*pt);
	os<<"]"<<endl;
      }
      os.close();
      exit(0);
    }
}

void Graph::postorder(int v) {
  col[v]=1;
  std::vector<int>::iterator pt;
  for (pt=tree_adj_list[v].begin(); pt!=tree_adj_list[v].end(); pt++)
    if (col[*pt]==0)
      postorder(*pt);
  _postorder[v]= ++po;
  inv_postorder[po]=v;
  col[v]=2;
}

void Graph::visit_cut(int u) {
  
  //std::vector<int>::iterator pt, p;
  //for (pt=tree_adj_list[u].begin(); pt!=tree_adj_list[u].end(); pt++)
  //	if (col[*pt] ==0) //v has not been seen before
  //		visit_cuts(*pt);
  
  if (marcoverbose>=4)
    cout<<cid<<"postorder: "<<_postorder[u]<<" "<<u+1<<endl;
 cut_order[u] = ++cid;
  //++cid;
  cut[cid].first=u;
  //cut[dfs[u]].push_back(pair<int, int> (u,NULL));
  std::vector<int>::iterator pt,p;
  for (pt=tree_adj_list[u].begin(); pt!=tree_adj_list[u].end(); pt++) {
    if (_postorder[*pt]<_postorder[u])
      ND[u] += ND[*pt];
  }

  ND[u]+=1;

  if (marcoverbose>=4)
    printf("v=%d ND=%d cutsize=%lu ", u+1, ND[u], cut[cid].second.size());
  for (pt=tree_adj_list[u].begin(); pt!=tree_adj_list[u].end(); pt++)
    if (_postorder[*pt]<=_postorder[u] && _postorder[*pt]>_postorder[u]
	-ND[u]) {
      //cut[dfs[u]]=cut[dfs[u]]+cut[dfs[*pt]];
      //cut[dfs[u]].push_back(pair<int, int> (*pt,dfs[*pt]));
      for (p=cut[cut_order[*pt]].second.begin(); p
	     !=cut[cut_order[*pt]].second.end(); p++) {
	if ((_postorder[aug_edges[*p].from] > _postorder[u] || _postorder[aug_edges[*p].from]
	     <= _postorder[u]-ND[u]) || (_postorder[aug_edges[*p].to]
					 > _postorder[u] || _postorder[aug_edges[*p].to] <= _postorder[u]
					 -ND[u]))
	  {
	    cut[cid].second.push_back(*p);
	    if (marcoverbose>=4)
	      printf(" e %d %d ",aug_edges[*p].from+1,aug_edges[*p].to+1);
	  }
      }
    }
    else // if  (_postorder[*pt]>_postorder[u])
      {
	bridge[cut_order[u]]=*pt;
      }

  
  for (pt=aug_adj_list[u].begin(); pt!=aug_adj_list[u].end(); pt++) {
    if (_postorder[*pt]>_postorder[u] || _postorder[*pt]<=_postorder[u]
	-ND[u]) {
      int id=adjacency_matrix[u][*pt];
      cut[cid].second.push_back(id);
      if (marcoverbose>=4)
	printf(" x%d %d %d %d ",*pt+1,id,aug_edges[id].from+1,aug_edges[id].to+1);
    }



    //		p=find(cut[cid].second.begin(), cut[cid].second.end(), id);
    //		if (p==cut[cid].second.end())
    
    //		else
    //			cut[cid].second.erase(p);
  }
}
























void Graph::read_solution(const char *filename) {
  
  //tmp = strtok(strdup(id.c_str()), ":");
  char buf[255]; // line buffer
  //int nn, en = 0;
  int idt = -1; // for doublechecking file definition (counts the read edges)

  tot_cost=0;
  
  std::ifstream is;
  is.open(filename);
  
  if (!is.is_open()) {
    cerr<<"Instance file not found\n";
    exit(1);
  }
  
  while (!is.eof()) {
    is.getline(buf, 255); // process each line
    //printf("%s\n", buf);
    fflush(stdout);
    switch (buf[0]) {
    case 'a': {
      // reads the edge information and add the edge between the 
      // corresponding nodes
      if (marcoverbose==3)
	cout<<buf<<endl;
      char *tmp = strtok(buf, " "); // splits buf among the spaces
      tmp = strtok(0, " "); // consider the first number
      int v = atoi(tmp) - 1;
      tmp = strtok(0, " "); // and now the second one
      int w = atoi(tmp) - 1;
      //	tmp = strtok(0, " "); // and now the third one
      //long cost = atoi(tmp);
      assert(w>=0 && w<num_of_vertices);
      assert(v>=0 && v<num_of_vertices);
      //if (adjacency_matrix[v][w] == 0)
      {
	idt++;
	if (v > w) {
	  int h = v;
	  v = w;
	  w = h;
	}
	
      }
      //sol_adj_list[v].push_back(w);
      //sol_adj_list[w].push_back(v);
      sol_adjacency_matrix[v][w] = sol_adjacency_matrix[w][v] = 1;
      tot_cost += aug_edges[adjacency_matrix[v][w]].weight;
    }
      break;
    case 'c':
    case ' ':
    case '\n':
      // ignore the comments and the empty lines
      break;
    default:
      //std::cerr << "Error while reading the input file " << id << std::endl
      //  << "the line " << buf << " was not understandable" << std::endl;
      break;
    }
  }
  
  is.close();
  
  cout<<"Solution read"<<endl;
}



void Graph::check() {
  ostringstream namebuf;
  solution=true;

  for (int l=0; l<num_of_vertices-1; l++) {
    namebuf.str("");
    namebuf<<"edge cut "<<cut[l].first+1;
    
    std::vector<int>::iterator pt2;
    bool covered=false;
    for (pt2=cut[l].second.begin(); pt2!=cut[l].second.end(); pt2++)
      if (sol_adjacency_matrix[aug_edges[*pt2].from][aug_edges[*pt2].to] == 1)
	{
	  covered=true;
	  break;
	}
    if (covered == false)
      {
	cout<<namebuf.str().c_str()<<" "<<" not covered"<<endl;
	solution = false;
      }
  }
  if (solution==true)
    {
      cout<<"The graph is 2-edge-connected"<<endl;
      cout<<"The augmentation cost is "<<tot_cost<<endl;
    }
  else
    {
      cout<<"The graph is NOT 2-edge connected"<<endl;
    }
}















