#include <cstdlib>
#include <vector>
#include <map>
#include <iostream>
#include <cstring>
#include <algorithm>

extern int marcoverbose;

  
  class Edge {
    friend std::ostream& operator<<(std::ostream &os, const Edge &e) {
      //std::ostream& scipexamples::operator<<(std::ostream& os, const Edge& e) {
  os <<"e "<< e.from+1<<" "<<e.to+1<<" ";//<<e.weight;
  return os;
}
  public:
    
    int from;					// edge in the shrinked tree
    int to;
    //int u;						// original edge of A.
    //int v;
    //int weight;
    //double weight;
    long double weight;
    int idx; 					// index in aedges
    
    Edge() {};				// Constructor
    ~Edge() {};				// Destructor
    
    // This function is required when using sort with STL list
    bool operator<(const Edge& a) const {
      //return this->weight < a.weight;
      if (this->from < a.from)
	return true;
      else if (this->from == a.from)
	return (this->to < a.to);
      else 
	return false;
    };
    
    Edge(const Edge &a) {
      if (&a!=NULL && &a!=this)
	{	from = a.from;
	  to = a.to;
	  weight=a.weight;
	  idx=a.idx;
	} 
    };
    Edge operator=(const Edge a) {
      from = a.from;
      to = a.to;
      weight=a.weight;
      idx=a.idx;
      return *this;
    }
  };
  
  class _cut {
  public:
    _cut() {};
    ~_cut() {};
    int first;
    std::vector<int> second;
  } ;
  
  class Graph {
  public:
    Graph() {};
    Graph(const char *instance_name);
    ~Graph() {};
    
    int num_of_vertices;
    int **adjacency_matrix;
    int **sol_adjacency_matrix;
    //  vector<int> degree;
    std::vector< std::vector<int> > tree_adj_list;
    std::vector< std::vector<int> > aug_adj_list;
    std::map<const int, Edge> aug_edges;
    std::map<const int, Edge> tree_edges;
    void create_cuts();
    std::vector< _cut > cut;
    bool solution;
    void read_solution(const char *filename);
    void check();

    long double tot_cost;
  private:
    void postorder(int u);
    void visit_cut(int u);
    std::vector< int > cut_order;
    std::vector< int > bridge;
    std::vector< int > _postorder;
    std::vector< int > inv_postorder;
    std::vector< int > ND;
    std::vector< int > col;
    int cid,po;
  };
