/*
* @author Marco Chiarandini
*/

#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <time.h>
#include "e12aug.hpp"


using namespace std;

const char app_err [] = "v2ec error: ";
const char usage [] =
    "Usage: v2ec <instance file> <solution file>\n"
    "Options:\n"
	"  -h        Display this information\n";



char* instfilename = NULL;

char* resfilename = NULL;

int marcoverbose = 2;

void tokenize(const string& str, vector<string>& tokens) {
	const string delimiters = " ";
    // Make sure the vector is empty
    tokens.clear();
    // Skip delimiters at beginning.
    string::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    string::size_type pos     = str.find_first_of(delimiters, lastPos);
    while (string::npos != pos || string::npos != lastPos) {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delimiters.  Note the "not_of"
        lastPos = str.find_first_not_of(delimiters, pos);
        // Find next "non-delimiter"
        pos = str.find_first_of(delimiters, lastPos);
    }
}





int main(int argc, char *argv[]) {
    // after options (if any), there must be a parameter
    // left, the source file name
    if (argc < 3) {
        cout << usage;
        exit(EXIT_FAILURE);
    }

	instfilename = argv[1];
	resfilename = argv[2];

    // check existance of the input file
    ifstream in(instfilename, ios::in);
    if (in == 0) {
        cerr << app_err << " can't open "
        << instfilename << endl;
        exit(EXIT_FAILURE);
    }
    in.close();

    // check existance of the input file
    ifstream in2(resfilename, ios::in);
    if (in2 == 0) {
        cerr << app_err << " can't open "
        << resfilename << endl;
        exit(EXIT_FAILURE);
    }
    in2.close();

	//- LOAD & INITIALIZE
   Graph G(instfilename);
   G.create_cuts();

   G.read_solution(resfilename);
   G.check();
   
   return EXIT_SUCCESS;

}


