# Example Python3 Code for the lecture on Graph Theory in DM534 by Daniel Merkle Nov. 28, 2017.

from math import *
from copy import *
from random import *
from time import *

# Assume M and N are both square (size x size) matrices 

def multModSquareMatrices(M,N):
    size = len(M)
    result = [[inf for x in range(size)] for y in range(size)]

    for i in range(size):
        for j in range(size):
            for k in range(size):
                result[i][j] = min(result[i][j], M[i][k] + N[k][j])
                
    return result

def addSquareMatrices(M,N):
    size = len(M)
    result = [[0 for x in range(size)] for y in range(size)]

    for i in range(size):
        for j in range(size):
            result[i][j] = M[i][k] + N[k][j]
                
    return result


def printMatrix(M):
    for row in R:
        print(["%3.0f" % a for a in row])
    print("\n")


# make a random edge weight matrix of size x size 
size=100
W = [[0 for x in range(size)] for y in range(size)]
for i in range(size):
    for j in range(i,size):
        r = randint(0,10)
        W[i][j] = r
        W[j][i] = r

# make a copy of the edge weight matrix W
R = deepcopy(W)

print("Comparing runtimes for distance matrix computation for matrices of size %d x %d"%(size,size))

# find the distance matrix by (n-2) subsequent matrix matrix multiplications
# R = (((W*W)*W)*...*W) = W^(n-1)
t1 = time()     
for i in range(0,size-2):
    R = multModSquareMatrices(R,W)
print("The n-2 multiplications for computing D took %3.2f seconds"%(time()-t1))

# set the R=W (re-initialize)
R = deepcopy(W)

# find the distance matrix by ceil(log_2(n-1)) subsequent matrix matrix mulitplications via repeated squaring
# R = (((W^2)^2)^2...)^2 
t1 = time()     
for i in range(0,ceil(log2(size-1))):
    R = multModSquareMatrices(R,R)
print("The ceil(log_2(n-1)) multiplications took %3.2f seconds"%(time()-t1))
