# Prints a SAT program in CNF for the nxn queens problem. Each clause
# is a list of ints.

def pair2int(n,row,col):
    return n*(row-1)+col

def attackRestOfRowLeft(n,row,col): # returns a list of clauses
    lengthOfRest = n-col
    return [[-pair2int(n,row,col), -pair2int(n,row,col+k)] for k in range(1,lengthOfRest+1)]

def attackRestOfColumnDown(n,row,col): # returns a list of clauses
    lengthOfRest = n-row
    return [[-pair2int(n,row,col), -pair2int(n,row+k,col)] for k in range(1,lengthOfRest+1)]

def attackRestOfDiagonalRightDown(n,row,col): # returns a list of clauses
    lengthOfRest = min(n-row,n-col)
    return [[-pair2int(n,row,col), -pair2int(n,row+k,col+k)] for k in range(1,lengthOfRest+1)]

def attackRestOfDiagonalLeftDown(n,row,col): # returns a list of clauses
    lengthOfRest = min(n-row,col-1)
    return [[-pair2int(n,row,col), -pair2int(n,row+k,col-k)] for k in range(1,lengthOfRest+1)]

def rowNotEmpty(n,row): # returns a single clause
    return [pair2int(n,row,col) for col in range(1,n+1)]

n = int(input("Please input n:\n"))
clauses = []
for row in range(1,n+1):
    for col in range(1,n+1):
        clauses.extend(attackRestOfRowLeft(n,row,col))
        clauses.extend(attackRestOfColumnDown(n,row,col))
        clauses.extend(attackRestOfDiagonalRightDown (n,row,col))
        clauses.extend(attackRestOfDiagonalLeftDown (n,row,col))
for row in range(1,n+1):
    clauses.append(rowNotEmpty(n,row))

print("p cnf", n**2, len(clauses))        
for clause in clauses:
    clause.append(0)
    print(*clause) # The use of * during a call unpacks a list, i.e.,
                   # its elements become arguments of the call to
                   # print (exploiting that print can work with any
                   # number of arguments).
